<?php $products_show = get_sub_field('products_show'); ?>
<?php if (get_sub_field('shop_sidebar_section')) { ?>
	<div class="row">
		<div class="col-sm-18<?php if (get_sub_field('shop_sidebar_section_position') == 'left') echo ' col-sm-push-6'; ?>">
<?php } ?>
		<?php if (count($products_show) > 1) { ?>
			<ul class="nav nav-tabs" role="tablist">
				<?php if( $products_show && is_array($products_show) && in_array('new', $products_show) ) { ?>
					<li role="presentation" class="active"><a href="#new" aria-controls="new" role="tab" data-toggle="tab">
						<?php if (get_sub_field('new_title')) the_sub_field('new_title'); else echo 'Nowości'; ?>
					</a></li>
				<?php } ?>
				<?php if( $products_show && is_array($products_show) && in_array('bestseller', $products_show) ) { ?>
					<li role="presentation"><a href="#bestseller" aria-controls="bestseller" role="tab" data-toggle="tab">
						<?php if (get_sub_field('promo_title')) the_sub_field('bestsellers_title'); else echo 'Bestsellery'; ?>
					</a></li>
				<?php } ?>
				<?php if( $products_show && is_array($products_show) && in_array('promo', $products_show) ) { ?>
					<li role="presentation"><a href="#promo" aria-controls="promo" role="tab" data-toggle="tab">
						<?php if (get_sub_field('promo_title')) the_sub_field('promo_title'); else echo 'Promocje'; ?>
					</a></li>
				<?php } ?>
				<?php if( $products_show && is_array($products_show) && in_array('custom', $products_show) ) {
					if( have_rows('custom_products') ):
						$cus = 0;
						while ( have_rows('custom_products') ) : the_row(); ?>
							<li role="presentation"><a href="#cus<?php echo $cus; ?>" aria-controls="cus<?php echo $cus; ?>" role="tab" data-toggle="tab">
								<?php if (get_sub_field('custom_title')) the_sub_field('custom_title'); else echo 'Wybrane'; ?>
							</a></li>
						<?php $cus++;
						endwhile;
					endif; ?>
				<?php } ?>
				<?php if( $products_show && is_array($products_show) && in_array('categories', $products_show) ) { ?>
					<li role="presentation"><a href="#cat" aria-controls="cat" role="tab" data-toggle="tab">
						<?php if (get_sub_field('category_title')) the_sub_field('category_title'); else echo 'Kategorie'; ?>
					</a></li>
				<?php } ?>
			</ul>
		<?php } ?>

		<div class="tab-content">
			<?php if( $products_show && is_array($products_show) && in_array('new', $products_show) ) { ?>
				<div role="tabpanel" class="tab-pane active" id="new">
					<?php if (get_sub_field('products_number')) {
						$products_number = get_sub_field('products_number');
					} else {
						$products_number == -1;
					}
					$products = new WP_Query( array (
						'post_type' => 'product',
						'post_status' => 'publish',
						'posts_per_page' => $products_number,
						'caller_get_posts'=> 1
					) );
					
					if ( $products->have_posts() ) : ?>
						<div class="woocommerce">
							<ul class="row products">
								<?php while ( $products->have_posts() ) : $products->the_post(); ?>
									<?php wc_get_template_part( 'content', 'product' ); ?>
								<?php endwhile; ?>
							</ul>
						</div>
					<?php endif;
					wp_reset_query(); ?>
				</div>
			<?php } ?>

			<?php if( $products_show && is_array($products_show) && in_array('bestseller', $products_show) ) { ?>
				<div role="tabpanel" class="tab-pane" id="bestseller">
					<?php if (get_sub_field('products_number')) {
						$bestsellers_number = get_sub_field('products_number');
						echo do_shortcode('[best_selling_products per_page='.$bestsellers_number.']');
					} else {
						echo do_shortcode('[best_selling_products]');
					} ?>
				</div>
			<?php } ?>
			
			<?php if( $products_show && is_array($products_show) && in_array('promo', $products_show) ) { ?>
				<div role="tabpanel" class="tab-pane" id="promo">
					<?php if (get_sub_field('promo_number')) {
						$promo_number = get_sub_field('promo_number');
						echo do_shortcode('[sale_products per_page='.$promo_number.']');
					} else {
						echo do_shortcode('[sale_products]');
					} ?>
				</div>
			<?php } ?>
			
			<?php if ($products_show && is_array($products_show) && in_array('custom', $products_show)) {
				if (have_rows('custom_products')):
					$cust = 0;
					while (have_rows('custom_products')) : the_row(); 
						$custom_product = get_sub_field('custom_product');
						if( $custom_product ): ?>					
							<div role="tabpanel" class="woocommerce tab-pane<?php if ($cust == 0) echo ' active'; ?>" id="cus<?php echo $cust; ?>">
								<ul class="row products">
									<?php foreach( $custom_product as $post ):
										setup_postdata( $post ); ?>
										<?php wc_get_template_part( 'content', 'product' ); ?>
									<?php endforeach;
									wp_reset_postdata(); ?>
								</ul>
							</div>
						<?php endif; ?>
					<?php $cust++;
					endwhile;
				endif; ?>
			<?php } ?>
			
			<?php if( $products_show && is_array($products_show) && in_array('categories', $products_show) ) { ?>
				<div role="tabpanel" class="woocommerce tab-pane" id="cat">
				<?php $terms = get_terms( 'product_cat' );
				if ( $terms ) { ?>			
						<ul class="row products product-cats">    
							<?php foreach ( $terms as $term ) {
								if((get_sub_field('show_top_categories') and $term->parent == 0) or !get_sub_field('show_top_categories')){ ?>
									<li class="category same-height-products product">
										<a href="<?php echo esc_url( get_term_link( $term ) ); ?>" class="<?php echo $term->slug; ?>">
											<?php woocommerce_subcategory_thumbnail( $term ); ?>
											<h2 class="woocommerce-loop-product__title">								
												<?php echo $term->name; ?>								
											</h2>
										</a>                                                                   
									</li>
								<?php }
							} ?>     
						</ul>
					
				<?php } ?>
				</div>
			<?php } ?>
			
		</div>
<?php if (get_sub_field('shop_sidebar_section')) { ?>
		</div>
		<div class="shop-sidebar wow col-sm-6<?php if (get_sub_field('shop_sidebar_section_position') == 'left') echo ' col-sm-pull-18 fadeInLeft'; else echo ' fadeInRight';?>">
			<?php
				/**
				 * woocommerce_sidebar hook.
				 *
				 * @hooked woocommerce_get_sidebar - 10
				 */
				do_action( 'woocommerce_sidebar' );
			?>
		</div>
	</div>
<?php } ?>